divert(-1)

###############################################################
# ZX SYSTEM VARIABLES BASIC USER CONFIGURATION
# rebuild the library if changes are made
#

# Values Expected by Basic

define(`__SYS_IY', 0x5c3a)
define(`__SYS_HLP', 0x2758)

# System Variables - Absolute Addresses
# See https://github.com/z88dk/techdocs/blob/master/targets/zx-next/nextos/

define(`__SYSVAR_SWAP', 0x5b00)
define(`__SYSVAR_STOO', 0x5b10)
define(`__SYSVAR_YOUNGER', 0x5b21)
define(`__SYSVAR_REGNUOY', 0x5b2a)
define(`__SYSVAR_ONERR', 0x5b3a)
define(`__SYSVAR_OLDHL', 0x5b52)
define(`__SYSVAR_OLDBC', 0x5b54)
define(`__SYSVAR_OLDAF', 0x5b56)
define(`__SYSVAR_TARGET', 0x5b58)
define(`__SYSVAR_RETADDR', 0x5b5a)
define(`__SYSVAR_BANKM', 0x5b5c)
define(`__SYSVAR_RAMRST', 0x5b5d)
define(`__SYSVAR_RAMERR', 0x5b5e)
define(`__SYSVAR_BAUD', 0x5b5f)
define(`__SYSVAR_SERFL', 0x5b61)
define(`__SYSVAR_COL', 0x5b63)
define(`__SYSVAR_WIDTH', 0x5b64)
define(`__SYSVAR_TVPARS', 0x5b65)
define(`__SYSVAR_FLAGS3', 0x5b66)
define(`__SYSVAR_BANK678', 0x5b67)
define(`__SYSVAR_FLAGN', 0x5b68)
define(`__SYSVAR_MAXBNK', 0x5b69)
define(`__SYSVAR_OLDSP', 0x5b6a)
define(`__SYSVAR_SYNRET', 0x5b6c)
define(`__SYSVAR_LASTV', 0x5b6e)
define(`__SYSVAR_TILEBNKL', 0x5b73)
define(`__SYSVAR_TILEML', 0x5b74)
define(`__SYSVAR_TILEBNK2', 0x5b75)
define(`__SYSVAR_TILEM2', 0x5b76)
define(`__SYSVAR_NXTBNK', 0x5b77)
define(`__SYSVAR_DATABNK', 0x5b78)
define(`__SYSVAR_LODDRV', 0x5b79)
define(`__SYSVAR_SAVDRV', 0x5b7a)
define(`__SYSVAR_L2SOFT', 0x5b7b)
define(`__SYSVAR_TILEWL', 0x5b7c)
define(`__SYSVAR_TILEW2', 0x5b7e)
define(`__SYSVAR_TILEOFFL', 0x5b80)
define(`__SYSVAR_TILEOFF2', 0x5b82)
define(`__SYSVAR_COORDSL', 0x5b84)
define(`__SYSVAR_COORDS2', 0x5b86)
define(`__SYSVAR_COORDSULA', 0x5b88)
define(`__SYSVAR_COORDSHR', 0x5b8a)
define(`__SYSVAR_COORDSHC', 0x5b8c)
define(`__SYSVAR_INKL', 0x5b8e)
define(`__SYSVAR_INK2', 0x5b8f)
define(`__SYSVAR_ATTRULA', 0x5b90)
define(`__SYSVAR_ATTRHR', 0x5b91)
define(`__SYSVAR_ATTRHC', 0x5b92)
define(`__SYSVAR_INKMASK', 0x5b93)
define(`__SYSVAR_TMPVARS', 0x5b94)

define(`__SYSVAR_TSTACK', 0x5bff)

define(`__SYSVAR_KSTATE', 0x5c00)
define(`__SYSVAR_LASTK', 0x5c08)
define(`__SYSVAR_REPDEL', 0x5c09)
define(`__SYSVAR_REPPER', 0x5c0a)
define(`__SYSVAR_DEFADD', 0x5c0b)
define(`__SYSVAR_KDATA', 0x5c0d)
define(`__SYSVAR_TVDATA', 0x5c0e)
define(`__SYSVAR_STRMS', 0x5c10)
define(`__SYSVAR_CHARS', 0x5c36)
define(`__SYSVAR_RASP', 0x5c38)
define(`__SYSVAR_PIP', 0x5c39)
define(`__SYSVAR_ERRNR', 0x5c3a)
define(`__SYSVAR_FLAGS', 0x5c3b)
define(`__SYSVAR_TVFLAG', 0x5c3c)
define(`__SYSVAR_ERRSP', 0x5c3d)
define(`__SYSVAR_LISTSP', 0x5c3f)
define(`__SYSVAR_MODE', 0x5c41)
define(`__SYSVAR_NEWPPC', 0x5c42)
define(`__SYSVAR_NSPPC', 0x5c44)
define(`__SYSVAR_PPC', 0x5c45)
define(`__SYSVAR_SUBPPC', 0x5c47)
define(`__SYSVAR_BORDCR', 0x5c48)
define(`__SYSVAR_EPPC', 0x5c49)
define(`__SYSVAR_VARS', 0x5c4b)
define(`__SYSVAR_DEST', 0x5c4d)
define(`__SYSVAR_CHANS', 0x5c4f)
define(`__SYSVAR_CURCHL', 0x5c51)
define(`__SYSVAR_PROG', 0x5c53)
define(`__SYSVAR_NXTLIN', 0x5c55)
define(`__SYSVAR_DATADD', 0x5c57)
define(`__SYSVAR_ELINE', 0x5c59)
define(`__SYSVAR_KCUR', 0x5c5b)
define(`__SYSVAR_CHADD', 0x5c5d)
define(`__SYSVAR_XPTR', 0x5c5f)
define(`__SYSVAR_WORKSP', 0x5c61)
define(`__SYSVAR_STKBOT', 0x5c63)
define(`__SYSVAR_STKEND', 0x5c65)
define(`__SYSVAR_BREG', 0x5c67)
define(`__SYSVAR_MEM', 0x5c68)
define(`__SYSVAR_FLAGS2', 0x5c6a)
define(`__SYSVAR_DFSZ', 0x5c6b)
define(`__SYSVAR_STOP', 0x5c6c)
define(`__SYSVAR_OLDPPC', 0x5c6e)
define(`__SYSVAR_OSPPC', 0x5c70)
define(`__SYSVAR_FLAGX', 0x5c71)
define(`__SYSVAR_STRLEN', 0x5c72)
define(`__SYSVAR_TADDR', 0x5c74)
define(`__SYSVAR_SEED', 0x5c76)
define(`__SYSVAR_FRAMES', 0x5c78)
define(`__SYSVAR_UDG', 0x5c7b)
define(`__SYSVAR_COORDS', 0x5c7d)
define(`__SYSVAR_GMODE', 0x5c7f)
define(`__SYSVAR_PRCC', 0x5c80)
define(`__SYSVAR_ECHOE', 0x5c82)
define(`__SYSVAR_DFCC', 0x5c84)
define(`__SYSVAR_DFCCL', 0x5c86)
define(`__SYSVAR_SPOSN', 0x5c88)
define(`__SYSVAR_SPOSNL', 0x5c8a)
define(`__SYSVAR_SCRCT', 0x5c8c)
define(`__SYSVAR_ATTRP', 0x5c8d)
define(`__SYSVAR_MASKP', 0x5c8e)
define(`__SYSVAR_ATTRT', 0x5c8f)
define(`__SYSVAR_MASKT', 0x5c90)
define(`__SYSVAR_PFLAG', 0x5c91)
define(`__SYSVAR_MEMBOT', 0x5c92)
define(`__SYSVAR_NMIADD', 0x5cb0)
define(`__SYSVAR_RAMTOP', 0x5cb2)
define(`__SYSVAR_PRAMT', 0x5cb4)

# Basic Error Codes
# See http://www.worldofspectrum.org/ZXBasicManual/zxmanappb.html
# (the value written to __SYSVAR_ERRNR will be one less than these numbers)

define(`__ERRB_0_OK', 0)
define(`__ERRB_1_NEXT_WITHOUT_FOR', 1)
define(`__ERRB_2_VARIABLE_NOT_FOUND', 2)
define(`__ERRB_3_SUBSCRIPT_WRONG', 3)
define(`__ERRB_4_OUT_OF_MEMORY', 4)
define(`__ERRB_5_OUT_OF_SCREEN', 5)
define(`__ERRB_6_NUMBER_TOO_BIG', 6)
define(`__ERRB_7_RETURN_WITHOUT_GOSUB', 7)
define(`__ERRB_8_END_OF_FILE', 8)
define(`__ERRB_9_STOP_STATEMENT', 9)
define(`__ERRB_A_INVALID_ARGUMENT', 10)
define(`__ERRB_B_INTEGER_OUT_OF_RANGE', 11)
define(`__ERRB_C_NONSENSE_IN_BASIC', 12)
define(`__ERRB_D_BREAK_CONT_REPEATS', 13)
define(`__ERRB_E_OUT_OF_DATA', 14)
define(`__ERRB_F_INVALID_FILENAME', 15)
define(`__ERRB_G_NO_ROOM_FOR_LINE', 16)
define(`__ERRB_H_STOP_IN_INPUT', 17)
define(`__ERRB_I_FOR_WITHOUT_NEXT', 18)
define(`__ERRB_J_INVALID_IO_DEVICE', 19)
define(`__ERRB_K_INVALID_COLOUR', 20)
define(`__ERRB_K_INVALID_COLOR', 20)
define(`__ERRB_L_BREAK_INTO_PROGRAM', 21)
define(`__ERRB_M_RAMTOP_NO_GOOD', 22)
define(`__ERRB_N_STATEMENT_LOST', 23)
define(`__ERRB_O_INVALID_STREAM', 24)
define(`__ERRB_P_FN_WITHOUT_DEF', 25)
define(`__ERRB_Q_PARAMETER_ERROR', 26)
define(`__ERRB_R_TAPE_LOADING_ERROR', 27)

#
# END OF USER CONFIGURATION
###############################################################

divert(0)

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_PUB',
`
PUBLIC `__SYS_IY'
PUBLIC `__SYS_HLP'

PUBLIC `__SYSVAR_SWAP'
PUBLIC `__SYSVAR_STOO'
PUBLIC `__SYSVAR_YOUNGER'
PUBLIC `__SYSVAR_REGNUOY'
PUBLIC `__SYSVAR_ONERR'
PUBLIC `__SYSVAR_OLDHL'
PUBLIC `__SYSVAR_OLDBC'
PUBLIC `__SYSVAR_OLDAF'
PUBLIC `__SYSVAR_TARGET'
PUBLIC `__SYSVAR_RETADDR'
PUBLIC `__SYSVAR_BANKM'
PUBLIC `__SYSVAR_RAMRST'
PUBLIC `__SYSVAR_RAMERR'
PUBLIC `__SYSVAR_BAUD'
PUBLIC `__SYSVAR_SERFL'
PUBLIC `__SYSVAR_COL'
PUBLIC `__SYSVAR_WIDTH'
PUBLIC `__SYSVAR_TVPARS'
PUBLIC `__SYSVAR_FLAGS3'
PUBLIC `__SYSVAR_BANK678'
PUBLIC `__SYSVAR_FLAGN'
PUBLIC `__SYSVAR_MAXBNK'
PUBLIC `__SYSVAR_OLDSP'
PUBLIC `__SYSVAR_SYNRET'
PUBLIC `__SYSVAR_LASTV'
PUBLIC `__SYSVAR_TILEBNKL'
PUBLIC `__SYSVAR_TILEML'
PUBLIC `__SYSVAR_TILEBNK2'
PUBLIC `__SYSVAR_TILEM2'
PUBLIC `__SYSVAR_NXTBNK'
PUBLIC `__SYSVAR_DATABNK'
PUBLIC `__SYSVAR_LODDRV'
PUBLIC `__SYSVAR_SAVDRV'
PUBLIC `__SYSVAR_L2SOFT'
PUBLIC `__SYSVAR_TILEWL'
PUBLIC `__SYSVAR_TILEW2'
PUBLIC `__SYSVAR_TILEOFFL'
PUBLIC `__SYSVAR_TILEOFF2'
PUBLIC `__SYSVAR_COORDSL'
PUBLIC `__SYSVAR_COORDS2'
PUBLIC `__SYSVAR_COORDSULA'
PUBLIC `__SYSVAR_COORDSHR'
PUBLIC `__SYSVAR_COORDSHC'
PUBLIC `__SYSVAR_INKL'
PUBLIC `__SYSVAR_INK2'
PUBLIC `__SYSVAR_ATTRULA'
PUBLIC `__SYSVAR_ATTRHR'
PUBLIC `__SYSVAR_ATTRHC'
PUBLIC `__SYSVAR_INKMASK'
PUBLIC `__SYSVAR_TMPVARS'

PUBLIC `__SYSVAR_TSTACK'

PUBLIC `__SYSVAR_KSTATE'
PUBLIC `__SYSVAR_LASTK'
PUBLIC `__SYSVAR_REPDEL'
PUBLIC `__SYSVAR_REPPER'
PUBLIC `__SYSVAR_DEFADD'
PUBLIC `__SYSVAR_KDATA'
PUBLIC `__SYSVAR_TVDATA'
PUBLIC `__SYSVAR_STRMS'
PUBLIC `__SYSVAR_CHARS'
PUBLIC `__SYSVAR_RASP'
PUBLIC `__SYSVAR_PIP'
PUBLIC `__SYSVAR_ERRNR'
PUBLIC `__SYSVAR_FLAGS'
PUBLIC `__SYSVAR_TVFLAG'
PUBLIC `__SYSVAR_ERRSP'
PUBLIC `__SYSVAR_LISTSP'
PUBLIC `__SYSVAR_MODE'
PUBLIC `__SYSVAR_NEWPPC'
PUBLIC `__SYSVAR_NSPPC'
PUBLIC `__SYSVAR_PPC'
PUBLIC `__SYSVAR_SUBPPC'
PUBLIC `__SYSVAR_BORDCR'
PUBLIC `__SYSVAR_EPPC'
PUBLIC `__SYSVAR_VARS'
PUBLIC `__SYSVAR_DEST'
PUBLIC `__SYSVAR_CHANS'
PUBLIC `__SYSVAR_CURCHL'
PUBLIC `__SYSVAR_PROG'
PUBLIC `__SYSVAR_NXTLIN'
PUBLIC `__SYSVAR_DATADD'
PUBLIC `__SYSVAR_ELINE'
PUBLIC `__SYSVAR_KCUR'
PUBLIC `__SYSVAR_CHADD'
PUBLIC `__SYSVAR_XPTR'
PUBLIC `__SYSVAR_WORKSP'
PUBLIC `__SYSVAR_STKBOT'
PUBLIC `__SYSVAR_STKEND'
PUBLIC `__SYSVAR_BREG'
PUBLIC `__SYSVAR_MEM'
PUBLIC `__SYSVAR_FLAGS2'
PUBLIC `__SYSVAR_DFSZ'
PUBLIC `__SYSVAR_STOP'
PUBLIC `__SYSVAR_OLDPPC'
PUBLIC `__SYSVAR_OSPPC'
PUBLIC `__SYSVAR_FLAGX'
PUBLIC `__SYSVAR_STRLEN'
PUBLIC `__SYSVAR_TADDR'
PUBLIC `__SYSVAR_SEED'
PUBLIC `__SYSVAR_FRAMES'
PUBLIC `__SYSVAR_UDG'
PUBLIC `__SYSVAR_COORDS'
PUBLIC `__SYSVAR_GMODE'
PUBLIC `__SYSVAR_PRCC'
PUBLIC `__SYSVAR_ECHOE'
PUBLIC `__SYSVAR_DFCC'
PUBLIC `__SYSVAR_DFCCL'
PUBLIC `__SYSVAR_SPOSN'
PUBLIC `__SYSVAR_SPOSNL'
PUBLIC `__SYSVAR_SCRCT'
PUBLIC `__SYSVAR_ATTRP'
PUBLIC `__SYSVAR_MASKP'
PUBLIC `__SYSVAR_ATTRT'
PUBLIC `__SYSVAR_MASKT'
PUBLIC `__SYSVAR_PFLAG'
PUBLIC `__SYSVAR_MEMBOT'
PUBLIC `__SYSVAR_NMIADD'
PUBLIC `__SYSVAR_RAMTOP'
PUBLIC `__SYSVAR_PRAMT'

PUBLIC `__ERRB_0_OK'
PUBLIC `__ERRB_1_NEXT_WITHOUT_FOR'
PUBLIC `__ERRB_2_VARIABLE_NOT_FOUND'
PUBLIC `__ERRB_3_SUBSCRIPT_WRONG'
PUBLIC `__ERRB_4_OUT_OF_MEMORY'
PUBLIC `__ERRB_5_OUT_OF_SCREEN'
PUBLIC `__ERRB_6_NUMBER_TOO_BIG'
PUBLIC `__ERRB_7_RETURN_WITHOUT_GOSUB'
PUBLIC `__ERRB_8_END_OF_FILE'
PUBLIC `__ERRB_9_STOP_STATEMENT'
PUBLIC `__ERRB_A_INVALID_ARGUMENT'
PUBLIC `__ERRB_B_INTEGER_OUT_OF_RANGE'
PUBLIC `__ERRB_C_NONSENSE_IN_BASIC'
PUBLIC `__ERRB_D_BREAK_CONT_REPEATS'
PUBLIC `__ERRB_E_OUT_OF_DATA'
PUBLIC `__ERRB_F_INVALID_FILENAME'
PUBLIC `__ERRB_G_NO_ROOM_FOR_LINE'
PUBLIC `__ERRB_H_STOP_IN_INPUT'
PUBLIC `__ERRB_I_FOR_WITHOUT_NEXT'
PUBLIC `__ERRB_J_INVALID_IO_DEVICE'
PUBLIC `__ERRB_K_INVALID_COLOUR'
PUBLIC `__ERRB_K_INVALID_COLOR'
PUBLIC `__ERRB_L_BREAK_INTO_PROGRAM'
PUBLIC `__ERRB_M_RAMTOP_NO_GOOD'
PUBLIC `__ERRB_N_STATEMENT_LOST'
PUBLIC `__ERRB_O_INVALID_STREAM'
PUBLIC `__ERRB_P_FN_WITHOUT_DEF'
PUBLIC `__ERRB_Q_PARAMETER_ERROR'
PUBLIC `__ERRB_R_TAPE_LOADING_ERROR'
')

dnl#
dnl# LIBRARY BUILD TIME CONFIG FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_DEF',
`
defc `__SYS_IY' = __SYS_IY
defc `__SYS_HLP' = __SYS_HLP

defc `__SYSVAR_SWAP' = __SYSVAR_SWAP
defc `__SYSVAR_STOO' = __SYSVAR_STOO
defc `__SYSVAR_YOUNGER' = __SYSVAR_YOUNGER
defc `__SYSVAR_REGNUOY' = __SYSVAR_REGNUOY
defc `__SYSVAR_ONERR' = __SYSVAR_ONERR
defc `__SYSVAR_OLDHL' = __SYSVAR_OLDHL
defc `__SYSVAR_OLDBC' = __SYSVAR_OLDBC
defc `__SYSVAR_OLDAF' = __SYSVAR_OLDAF
defc `__SYSVAR_TARGET' = __SYSVAR_TARGET
defc `__SYSVAR_RETADDR' = __SYSVAR_RETADDR
defc `__SYSVAR_BANKM' = __SYSVAR_BANKM
defc `__SYSVAR_RAMRST' = __SYSVAR_RAMRST
defc `__SYSVAR_RAMERR' = __SYSVAR_RAMERR
defc `__SYSVAR_BAUD' = __SYSVAR_BAUD
defc `__SYSVAR_SERFL' = __SYSVAR_SERFL
defc `__SYSVAR_COL' = __SYSVAR_COL
defc `__SYSVAR_WIDTH' = __SYSVAR_WIDTH
defc `__SYSVAR_TVPARS' = __SYSVAR_TVPARS
defc `__SYSVAR_FLAGS3' = __SYSVAR_FLAGS3
defc `__SYSVAR_BANK678' = __SYSVAR_BANK678
defc `__SYSVAR_FLAGN' = __SYSVAR_FLAGN
defc `__SYSVAR_MAXBNK' = __SYSVAR_MAXBNK
defc `__SYSVAR_OLDSP' = __SYSVAR_OLDSP
defc `__SYSVAR_SYNRET' = __SYSVAR_SYNRET
defc `__SYSVAR_LASTV' = __SYSVAR_LASTV
defc `__SYSVAR_TILEBNKL' = __SYSVAR_TILEBNKL
defc `__SYSVAR_TILEML' = __SYSVAR_TILEML
defc `__SYSVAR_TILEBNK2' = __SYSVAR_TILEBNK2
defc `__SYSVAR_TILEM2' = __SYSVAR_TILEM2
defc `__SYSVAR_NXTBNK' = __SYSVAR_NXTBNK
defc `__SYSVAR_DATABNK' = __SYSVAR_DATABNK
defc `__SYSVAR_LODDRV' = __SYSVAR_LODDRV
defc `__SYSVAR_SAVDRV' = __SYSVAR_SAVDRV
defc `__SYSVAR_L2SOFT' = __SYSVAR_L2SOFT
defc `__SYSVAR_TILEWL' = __SYSVAR_TILEWL
defc `__SYSVAR_TILEW2' = __SYSVAR_TILEW2
defc `__SYSVAR_TILEOFFL' = __SYSVAR_TILEOFFL
defc `__SYSVAR_TILEOFF2' = __SYSVAR_TILEOFF2
defc `__SYSVAR_COORDSL' = __SYSVAR_COORDSL
defc `__SYSVAR_COORDS2' = __SYSVAR_COORDS2
defc `__SYSVAR_COORDSULA' = __SYSVAR_COORDSULA
defc `__SYSVAR_COORDSHR' = __SYSVAR_COORDSHR
defc `__SYSVAR_COORDSHC' = __SYSVAR_COORDSHC
defc `__SYSVAR_INKL' = __SYSVAR_INKL
defc `__SYSVAR_INK2' = __SYSVAR_INK2
defc `__SYSVAR_ATTRULA' = __SYSVAR_ATTRULA
defc `__SYSVAR_ATTRHR' = __SYSVAR_ATTRHR
defc `__SYSVAR_ATTRHC' = __SYSVAR_ATTRHC
defc `__SYSVAR_INKMASK' = __SYSVAR_INKMASK
defc `__SYSVAR_TMPVARS' = __SYSVAR_TMPVARS

defc `__SYSVAR_TSTACK' = __SYSVAR_TSTACK

defc `__SYSVAR_KSTATE' = __SYSVAR_KSTATE
defc `__SYSVAR_LASTK' = __SYSVAR_LASTK
defc `__SYSVAR_REPDEL' = __SYSVAR_REPDEL
defc `__SYSVAR_REPPER' = __SYSVAR_REPPER
defc `__SYSVAR_DEFADD' = __SYSVAR_DEFADD
defc `__SYSVAR_KDATA' = __SYSVAR_KDATA
defc `__SYSVAR_TVDATA' = __SYSVAR_TVDATA
defc `__SYSVAR_STRMS' = __SYSVAR_STRMS
defc `__SYSVAR_CHARS' = __SYSVAR_CHARS
defc `__SYSVAR_RASP' = __SYSVAR_RASP
defc `__SYSVAR_PIP' = __SYSVAR_PIP
defc `__SYSVAR_ERRNR' = __SYSVAR_ERRNR
defc `__SYSVAR_FLAGS' = __SYSVAR_FLAGS
defc `__SYSVAR_TVFLAG' = __SYSVAR_TVFLAG
defc `__SYSVAR_ERRSP' = __SYSVAR_ERRSP
defc `__SYSVAR_LISTSP' = __SYSVAR_LISTSP
defc `__SYSVAR_MODE' = __SYSVAR_MODE
defc `__SYSVAR_NEWPPC' = __SYSVAR_NEWPPC
defc `__SYSVAR_NSPPC' = __SYSVAR_NSPPC
defc `__SYSVAR_PPC' = __SYSVAR_PPC
defc `__SYSVAR_SUBPPC' = __SYSVAR_SUBPPC
defc `__SYSVAR_BORDCR' = __SYSVAR_BORDCR
defc `__SYSVAR_EPPC' = __SYSVAR_EPPC
defc `__SYSVAR_VARS' = __SYSVAR_VARS
defc `__SYSVAR_DEST' = __SYSVAR_DEST
defc `__SYSVAR_CHANS' = __SYSVAR_CHANS
defc `__SYSVAR_CURCHL' = __SYSVAR_CURCHL
defc `__SYSVAR_PROG' = __SYSVAR_PROG
defc `__SYSVAR_NXTLIN' = __SYSVAR_NXTLIN
defc `__SYSVAR_DATADD' = __SYSVAR_DATADD
defc `__SYSVAR_ELINE' = __SYSVAR_ELINE
defc `__SYSVAR_KCUR' = __SYSVAR_KCUR
defc `__SYSVAR_CHADD' = __SYSVAR_CHADD
defc `__SYSVAR_XPTR' = __SYSVAR_XPTR
defc `__SYSVAR_WORKSP' = __SYSVAR_WORKSP
defc `__SYSVAR_STKBOT' = __SYSVAR_STKBOT
defc `__SYSVAR_STKEND' = __SYSVAR_STKEND
defc `__SYSVAR_BREG' = __SYSVAR_BREG
defc `__SYSVAR_MEM' = __SYSVAR_MEM
defc `__SYSVAR_FLAGS2' = __SYSVAR_FLAGS2
defc `__SYSVAR_DFSZ' = __SYSVAR_DFSZ
defc `__SYSVAR_STOP' = __SYSVAR_STOP
defc `__SYSVAR_OLDPPC' = __SYSVAR_OLDPPC
defc `__SYSVAR_OSPPC' = __SYSVAR_OSPPC
defc `__SYSVAR_FLAGX' = __SYSVAR_FLAGX
defc `__SYSVAR_STRLEN' = __SYSVAR_STRLEN
defc `__SYSVAR_TADDR' = __SYSVAR_TADDR
defc `__SYSVAR_SEED' = __SYSVAR_SEED
defc `__SYSVAR_FRAMES' = __SYSVAR_FRAMES
defc `__SYSVAR_UDG' = __SYSVAR_UDG
defc `__SYSVAR_COORDS' = __SYSVAR_COORDS
defc `__SYSVAR_GMODE' = __SYSVAR_GMODE
defc `__SYSVAR_PRCC' = __SYSVAR_PRCC
defc `__SYSVAR_ECHOE' = __SYSVAR_ECHOE
defc `__SYSVAR_DFCC' = __SYSVAR_DFCC
defc `__SYSVAR_DFCCL' = __SYSVAR_DFCCL
defc `__SYSVAR_SPOSN' = __SYSVAR_SPOSN
defc `__SYSVAR_SPOSNL' = __SYSVAR_SPOSNL
defc `__SYSVAR_SCRCT' = __SYSVAR_SCRCT
defc `__SYSVAR_ATTRP' = __SYSVAR_ATTRP
defc `__SYSVAR_MASKP' = __SYSVAR_MASKP
defc `__SYSVAR_ATTRT' = __SYSVAR_ATTRT
defc `__SYSVAR_MASKT' = __SYSVAR_MASKT
defc `__SYSVAR_PFLAG' = __SYSVAR_PFLAG
defc `__SYSVAR_MEMBOT' = __SYSVAR_MEMBOT
defc `__SYSVAR_NMIADD' = __SYSVAR_NMIADD
defc `__SYSVAR_RAMTOP' = __SYSVAR_RAMTOP
defc `__SYSVAR_PRAMT' = __SYSVAR_PRAMT

defc `__ERRB_0_OK' = __ERRB_0_OK
defc `__ERRB_1_NEXT_WITHOUT_FOR' = __ERRB_1_NEXT_WITHOUT_FOR
defc `__ERRB_2_VARIABLE_NOT_FOUND' = __ERRB_2_VARIABLE_NOT_FOUND
defc `__ERRB_3_SUBSCRIPT_WRONG' = __ERRB_3_SUBSCRIPT_WRONG
defc `__ERRB_4_OUT_OF_MEMORY' = __ERRB_4_OUT_OF_MEMORY
defc `__ERRB_5_OUT_OF_SCREEN' = __ERRB_5_OUT_OF_SCREEN
defc `__ERRB_6_NUMBER_TOO_BIG' = __ERRB_6_NUMBER_TOO_BIG
defc `__ERRB_7_RETURN_WITHOUT_GOSUB' = __ERRB_7_RETURN_WITHOUT_GOSUB
defc `__ERRB_8_END_OF_FILE' = __ERRB_8_END_OF_FILE
defc `__ERRB_9_STOP_STATEMENT' = __ERRB_9_STOP_STATEMENT
defc `__ERRB_A_INVALID_ARGUMENT' = __ERRB_A_INVALID_ARGUMENT
defc `__ERRB_B_INTEGER_OUT_OF_RANGE' = __ERRB_B_INTEGER_OUT_OF_RANGE
defc `__ERRB_C_NONSENSE_IN_BASIC' = __ERRB_C_NONSENSE_IN_BASIC
defc `__ERRB_D_BREAK_CONT_REPEATS' = __ERRB_D_BREAK_CONT_REPEATS
defc `__ERRB_E_OUT_OF_DATA' = __ERRB_E_OUT_OF_DATA
defc `__ERRB_F_INVALID_FILENAME' = __ERRB_F_INVALID_FILENAME
defc `__ERRB_G_NO_ROOM_FOR_LINE' = __ERRB_G_NO_ROOM_FOR_LINE
defc `__ERRB_H_STOP_IN_INPUT' = __ERRB_H_STOP_IN_INPUT
defc `__ERRB_I_FOR_WITHOUT_NEXT' = __ERRB_I_FOR_WITHOUT_NEXT
defc `__ERRB_J_INVALID_IO_DEVICE' = __ERRB_J_INVALID_IO_DEVICE
defc `__ERRB_K_INVALID_COLOUR' = __ERRB_K_INVALID_COLOUR
defc `__ERRB_K_INVALID_COLOR' = __ERRB_K_INVALID_COLOR
defc `__ERRB_L_BREAK_INTO_PROGRAM' = __ERRB_L_BREAK_INTO_PROGRAM
defc `__ERRB_M_RAMTOP_NO_GOOD' = __ERRB_M_RAMTOP_NO_GOOD
defc `__ERRB_N_STATEMENT_LOST' = __ERRB_N_STATEMENT_LOST
defc `__ERRB_O_INVALID_STREAM' = __ERRB_O_INVALID_STREAM
defc `__ERRB_P_FN_WITHOUT_DEF' = __ERRB_P_FN_WITHOUT_DEF
defc `__ERRB_Q_PARAMETER_ERROR' = __ERRB_Q_PARAMETER_ERROR
defc `__ERRB_R_TAPE_LOADING_ERROR' = __ERRB_R_TAPE_LOADING_ERROR
')

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR C
dnl#

ifdef(`CFG_C_DEF',
`
`#define' `__SYS_IY'  SYS_IY
`#define' `__SYS_HLP'  SYS_HLP

`#define' `__SYSVAR_SWAP'  __SYSVAR_SWAP
`#define' `__SYSVAR_STOO'  __SYSVAR_STOO
`#define' `__SYSVAR_YOUNGER'  __SYSVAR_YOUNGER
`#define' `__SYSVAR_REGNUOY'  __SYSVAR_REGNUOY
`#define' `__SYSVAR_ONERR'  __SYSVAR_ONERR
`#define' `__SYSVAR_OLDHL'  __SYSVAR_OLDHL
`#define' `__SYSVAR_OLDBC'  __SYSVAR_OLDBC
`#define' `__SYSVAR_OLDAF'  __SYSVAR_OLDAF
`#define' `__SYSVAR_TARGET'  __SYSVAR_TARGET
`#define' `__SYSVAR_RETADDR'  __SYSVAR_RETADDR
`#define' `__SYSVAR_BANKM'  __SYSVAR_BANKM
`#define' `__SYSVAR_RAMRST'  __SYSVAR_RAMRST
`#define' `__SYSVAR_RAMERR'  __SYSVAR_RAMERR
`#define' `__SYSVAR_BAUD'  __SYSVAR_BAUD
`#define' `__SYSVAR_SERFL'  __SYSVAR_SERFL
`#define' `__SYSVAR_COL'  __SYSVAR_COL
`#define' `__SYSVAR_WIDTH'  __SYSVAR_WIDTH
`#define' `__SYSVAR_TVPARS'  __SYSVAR_TVPARS
`#define' `__SYSVAR_FLAGS3'  __SYSVAR_FLAGS3
`#define' `__SYSVAR_BANK678'  __SYSVAR_BANK678
`#define' `__SYSVAR_FLAGN'  __SYSVAR_FLAGN
`#define' `__SYSVAR_MAXBNK'  __SYSVAR_MAXBNK
`#define' `__SYSVAR_OLDSP'  __SYSVAR_OLDSP
`#define' `__SYSVAR_SYNRET'  __SYSVAR_SYNRET
`#define' `__SYSVAR_LASTV'  __SYSVAR_LASTV
`#define' `__SYSVAR_TILEBNKL'  __SYSVAR_TILEBNKL
`#define' `__SYSVAR_TILEML'  __SYSVAR_TILEML
`#define' `__SYSVAR_TILEBNK2'  __SYSVAR_TILEBNK2
`#define' `__SYSVAR_TILEM2'  __SYSVAR_TILEM2
`#define' `__SYSVAR_NXTBNK'  __SYSVAR_NXTBNK
`#define' `__SYSVAR_DATABNK'  __SYSVAR_DATABNK
`#define' `__SYSVAR_LODDRV'  __SYSVAR_LODDRV
`#define' `__SYSVAR_SAVDRV'  __SYSVAR_SAVDRV
`#define' `__SYSVAR_L2SOFT'  __SYSVAR_L2SOFT
`#define' `__SYSVAR_TILEWL'  __SYSVAR_TILEWL
`#define' `__SYSVAR_TILEW2'  __SYSVAR_TILEW2
`#define' `__SYSVAR_TILEOFFL'  __SYSVAR_TILEOFFL
`#define' `__SYSVAR_TILEOFF2'  __SYSVAR_TILEOFF2
`#define' `__SYSVAR_COORDSL'  __SYSVAR_COORDSL
`#define' `__SYSVAR_COORDS2'  __SYSVAR_COORDS2
`#define' `__SYSVAR_COORDSULA'  __SYSVAR_COORDSULA
`#define' `__SYSVAR_COORDSHR'  __SYSVAR_COORDSHR
`#define' `__SYSVAR_COORDSHC'  __SYSVAR_COORDSHC
`#define' `__SYSVAR_INKL'  __SYSVAR_INKL
`#define' `__SYSVAR_INK2'  __SYSVAR_INK2
`#define' `__SYSVAR_ATTRULA'  __SYSVAR_ATTRULA
`#define' `__SYSVAR_ATTRHR'  __SYSVAR_ATTRHR
`#define' `__SYSVAR_ATTRHC'  __SYSVAR_ATTRHC
`#define' `__SYSVAR_INKMASK'  __SYSVAR_INKMASK
`#define' `__SYSVAR_TMPVARS'  __SYSVAR_TMPVARS

`#define' `__SYSVAR_TSTACK'  __SYSVAR_TSTACK

`#define' `__SYSVAR_KSTATE'  __SYSVAR_KSTATE
`#define' `__SYSVAR_LASTK'  __SYSVAR_LASTK
`#define' `__SYSVAR_REPDEL'  __SYSVAR_REPDEL
`#define' `__SYSVAR_REPPER'  __SYSVAR_REPPER
`#define' `__SYSVAR_DEFADD'  __SYSVAR_DEFADD
`#define' `__SYSVAR_KDATA'  __SYSVAR_KDATA
`#define' `__SYSVAR_TVDATA'  __SYSVAR_TVDATA
`#define' `__SYSVAR_STRMS'  __SYSVAR_STRMS
`#define' `__SYSVAR_CHARS'  __SYSVAR_CHARS
`#define' `__SYSVAR_RASP'  __SYSVAR_RASP
`#define' `__SYSVAR_PIP'  __SYSVAR_PIP
`#define' `__SYSVAR_ERRNR'  __SYSVAR_ERRNR
`#define' `__SYSVAR_FLAGS'  __SYSVAR_FLAGS
`#define' `__SYSVAR_TVFLAG'  __SYSVAR_TVFLAG
`#define' `__SYSVAR_ERRSP'  __SYSVAR_ERRSP
`#define' `__SYSVAR_LISTSP'  __SYSVAR_LISTSP
`#define' `__SYSVAR_MODE'  __SYSVAR_MODE
`#define' `__SYSVAR_NEWPPC'  __SYSVAR_NEWPPC
`#define' `__SYSVAR_NSPPC'  __SYSVAR_NSPPC
`#define' `__SYSVAR_PPC'  __SYSVAR_PPC
`#define' `__SYSVAR_SUBPPC'  __SYSVAR_SUBPPC
`#define' `__SYSVAR_BORDCR'  __SYSVAR_BORDCR
`#define' `__SYSVAR_EPPC'  __SYSVAR_EPPC
`#define' `__SYSVAR_VARS'  __SYSVAR_VARS
`#define' `__SYSVAR_DEST'  __SYSVAR_DEST
`#define' `__SYSVAR_CHANS'  __SYSVAR_CHANS
`#define' `__SYSVAR_CURCHL'  __SYSVAR_CURCHL
`#define' `__SYSVAR_PROG'  __SYSVAR_PROG
`#define' `__SYSVAR_NXTLIN'  __SYSVAR_NXTLIN
`#define' `__SYSVAR_DATADD'  __SYSVAR_DATADD
`#define' `__SYSVAR_ELINE'  __SYSVAR_ELINE
`#define' `__SYSVAR_KCUR'  __SYSVAR_KCUR
`#define' `__SYSVAR_CHADD'  __SYSVAR_CHADD
`#define' `__SYSVAR_XPTR'  __SYSVAR_XPTR
`#define' `__SYSVAR_WORKSP'  __SYSVAR_WORKSP
`#define' `__SYSVAR_STKBOT'  __SYSVAR_STKBOT
`#define' `__SYSVAR_STKEND'  __SYSVAR_STKEND
`#define' `__SYSVAR_BREG'  __SYSVAR_BREG
`#define' `__SYSVAR_MEM'  __SYSVAR_MEM
`#define' `__SYSVAR_FLAGS2'  __SYSVAR_FLAGS2
`#define' `__SYSVAR_DFSZ'  __SYSVAR_DFSZ
`#define' `__SYSVAR_STOP'  __SYSVAR_STOP
`#define' `__SYSVAR_OLDPPC'  __SYSVAR_OLDPPC
`#define' `__SYSVAR_OSPPC'  __SYSVAR_OSPPC
`#define' `__SYSVAR_FLAGX'  __SYSVAR_FLAGX
`#define' `__SYSVAR_STRLEN'  __SYSVAR_STRLEN
`#define' `__SYSVAR_TADDR'  __SYSVAR_TADDR
`#define' `__SYSVAR_SEED'  __SYSVAR_SEED
`#define' `__SYSVAR_FRAMES'  __SYSVAR_FRAMES
`#define' `__SYSVAR_UDG'  __SYSVAR_UDG
`#define' `__SYSVAR_COORDS'  __SYSVAR_COORDS
`#define' `__SYSVAR_GMODE'  __SYSVAR_GMODE
`#define' `__SYSVAR_PRCC'  __SYSVAR_PRCC
`#define' `__SYSVAR_ECHOE'  __SYSVAR_ECHOE
`#define' `__SYSVAR_DFCC'  __SYSVAR_DFCC
`#define' `__SYSVAR_DFCCL'  __SYSVAR_DFCCL
`#define' `__SYSVAR_SPOSN'  __SYSVAR_SPOSN
`#define' `__SYSVAR_SPOSNL'  __SYSVAR_SPOSNL
`#define' `__SYSVAR_SCRCT'  __SYSVAR_SCRCT
`#define' `__SYSVAR_ATTRP'  __SYSVAR_ATTRP
`#define' `__SYSVAR_MASKP'  __SYSVAR_MASKP
`#define' `__SYSVAR_ATTRT'  __SYSVAR_ATTRT
`#define' `__SYSVAR_MASKT'  __SYSVAR_MASKT
`#define' `__SYSVAR_PFLAG'  __SYSVAR_PFLAG
`#define' `__SYSVAR_MEMBOT'  __SYSVAR_MEMBOT
`#define' `__SYSVAR_NMIADD'  __SYSVAR_NMIADD
`#define' `__SYSVAR_RAMTOP'  __SYSVAR_RAMTOP
`#define' `__SYSVAR_PRAMT'  __SYSVAR_PRAMT

`#define' `__ERRB_0_OK'  __ERRB_0_OK
`#define' `__ERRB_1_NEXT_WITHOUT_FOR'  __ERRB_1_NEXT_WITHOUT_FOR
`#define' `__ERRB_2_VARIABLE_NOT_FOUND'  __ERRB_2_VARIABLE_NOT_FOUND
`#define' `__ERRB_3_SUBSCRIPT_WRONG'  __ERRB_3_SUBSCRIPT_WRONG
`#define' `__ERRB_4_OUT_OF_MEMORY'  __ERRB_4_OUT_OF_MEMORY
`#define' `__ERRB_5_OUT_OF_SCREEN'  __ERRB_5_OUT_OF_SCREEN
`#define' `__ERRB_6_NUMBER_TOO_BIG'  __ERRB_6_NUMBER_TOO_BIG
`#define' `__ERRB_7_RETURN_WITHOUT_GOSUB'  __ERRB_7_RETURN_WITHOUT_GOSUB
`#define' `__ERRB_8_END_OF_FILE'  __ERRB_8_END_OF_FILE
`#define' `__ERRB_9_STOP_STATEMENT'  __ERRB_9_STOP_STATEMENT
`#define' `__ERRB_A_INVALID_ARGUMENT'  __ERRB_A_INVALID_ARGUMENT
`#define' `__ERRB_B_INTEGER_OUT_OF_RANGE'  __ERRB_B_INTEGER_OUT_OF_RANGE
`#define' `__ERRB_C_NONSENSE_IN_BASIC'  __ERRB_C_NONSENSE_IN_BASIC
`#define' `__ERRB_D_BREAK_CONT_REPEATS'  __ERRB_D_BREAK_CONT_REPEATS
`#define' `__ERRB_E_OUT_OF_DATA'  __ERRB_E_OUT_OF_DATA
`#define' `__ERRB_F_INVALID_FILENAME'  __ERRB_F_INVALID_FILENAME
`#define' `__ERRB_G_NO_ROOM_FOR_LINE'  __ERRB_G_NO_ROOM_FOR_LINE
`#define' `__ERRB_H_STOP_IN_INPUT'  __ERRB_H_STOP_IN_INPUT
`#define' `__ERRB_I_FOR_WITHOUT_NEXT'  __ERRB_I_FOR_WITHOUT_NEXT
`#define' `__ERRB_J_INVALID_IO_DEVICE'  __ERRB_J_INVALID_IO_DEVICE
`#define' `__ERRB_K_INVALID_COLOUR'  __ERRB_K_INVALID_COLOUR
`#define' `__ERRB_K_INVALID_COLOR'  __ERRB_K_INVALID_COLOR
`#define' `__ERRB_L_BREAK_INTO_PROGRAM'  __ERRB_L_BREAK_INTO_PROGRAM
`#define' `__ERRB_M_RAMTOP_NO_GOOD'  __ERRB_M_RAMTOP_NO_GOOD
`#define' `__ERRB_N_STATEMENT_LOST'  __ERRB_N_STATEMENT_LOST
`#define' `__ERRB_O_INVALID_STREAM'  __ERRB_O_INVALID_STREAM
`#define' `__ERRB_P_FN_WITHOUT_DEF'  __ERRB_P_FN_WITHOUT_DEF
`#define' `__ERRB_Q_PARAMETER_ERROR'  __ERRB_Q_PARAMETER_ERROR
`#define' `__ERRB_R_TAPE_LOADING_ERROR'  __ERRB_R_TAPE_LOADING_ERROR
')
